/* Gimple - Gimp in Guile
 * Copyright (C) 1998 Lauri Alanko <la@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "gimple.h"

static void query (void);
static void run	(char    *name, 
		 int      nparams, 
		 GParam  *param, 
		 int     *nreturn_vals, 
		 GParam **return_vals);
static void gimple_main (void* closure, int argc, char** argv);

GPlugInInfo PLUG_IN_INFO = 
{
	NULL,					/* init_proc */
	NULL,					/* quit_proc */
	query,				/* query_proc */
	run,					/* init_proc */
};

MAIN ();

static void
query (){
	gimp_install_procedure ("extension_gimple",
				"A Guile (Scheme) interpreter for scripting "
				"GIMP operations",
				"",
				"Lauri Alanko & Scott Goehring",
				"Lauri Alanko & Scott Goehring",
				"1997-1998",
				NULL,
				NULL,
				PROC_EXTENSION,
				0,0,
				NULL,NULL);
}

static void
run (char    *name,
     int      nparams,
     GParam  *param,
     int     *nreturn_vals,
     GParam **return_vals){
	/*  Init the interpreter  */
	gh_enter(0, NULL, gimple_main);
}

static void
gimple_main (void* closure, 
	     int argc, 
	     char** argv){
	int n;
	char *name="gimple";
	
	GParam* vals=gimp_run_procedure ("gimp_gimprc_query",
					 &n,
					 PARAM_STRING, "gimple-startup-command",
					 PARAM_END);
	if(vals[0].data.d_status!=STATUS_SUCCESS)
	    return;
	gimple_gparam_init();
	gimple_pdb_init();
	scm_compile_shell_switches(1, &name);
	scm_eval_0str(vals[1].data.d_string);
}


