/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimptransformtools_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

/**
 * gimp_flip:
 * @drawable_ID: The affected drawable.
 * @flip_type: Type of flip.
 *
 * Flip the specified drawable about its center either vertically or
 * horizontally.
 *
 * This tool flips the specified drawable if no selection exists. If a
 * selection exists, the portion of the drawable which lies under the
 * selection is cut from the drawable and made into a floating
 * selection which is then flipd by the specified amount. The return
 * value is the ID of the flipped drawable. If there was no selection,
 * this will be equal to the drawable ID supplied as input. Otherwise,
 * this will be the newly created and flipped drawable. The flip type
 * parameter indicates whether the flip will be applied horizontally or
 * vertically.
 *
 * Returns: The flipped drawable.
 */
gint32
gimp_flip (gint32              drawable_ID,
	   GimpOrientationType flip_type)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_flip",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, flip_type,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_perspective:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @x0: The new x coordinate of upper-left corner of original bounding box.
 * @y0: The new y coordinate of upper-left corner of original bounding box.
 * @x1: The new x coordinate of upper-right corner of original bounding box.
 * @y1: The new y coordinate of upper-right corner of original bounding box.
 * @x2: The new x coordinate of lower-left corner of original bounding box.
 * @y2: The new y coordinate of lower-left corner of original bounding box.
 * @x3: The new x coordinate of lower-right corner of original bounding box.
 * @y3: The new y coordinate of lower-right corner of original bounding box.
 *
 * Perform a possibly non-affine transformation on the specified
 * drawable.
 *
 * This tool performs a possibly non-affine transformation on the
 * specified drawable by allowing the corners of the original bounding
 * box to be arbitrarily remapped to any values. The specified drawable
 * is remapped if no selection exists. However, if a selection exists,
 * the portion of the drawable which lies under the selection is cut
 * from the drawable and made into a floating selection which is then
 * remapped as specified. The interpolation parameter can be set to
 * TRUE to indicate that either linear or cubic interpolation should be
 * used to smooth the resulting remapped drawable. The return value is
 * the ID of the remapped drawable. If there was no selection, this
 * will be equal to the drawable ID supplied as input. Otherwise, this
 * will be the newly created and remapped drawable. The 4 coordinates
 * specify the new locations of each corner of the original bounding
 * box. By specifying these values, any affine transformation
 * (rotation, scaling, translation) can be affected. Additionally,
 * these values can be specified such that the resulting transformed
 * drawable will appear to have been projected via a perspective
 * transform.
 *
 * Returns: The newly mapped drawable.
 */
gint32
gimp_perspective (gint32   drawable_ID,
		  gboolean interpolation,
		  gdouble  x0,
		  gdouble  y0,
		  gdouble  x1,
		  gdouble  y1,
		  gdouble  x2,
		  gdouble  y2,
		  gdouble  x3,
		  gdouble  y3)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_perspective",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, x0,
				    GIMP_PDB_FLOAT, y0,
				    GIMP_PDB_FLOAT, x1,
				    GIMP_PDB_FLOAT, y1,
				    GIMP_PDB_FLOAT, x2,
				    GIMP_PDB_FLOAT, y2,
				    GIMP_PDB_FLOAT, x3,
				    GIMP_PDB_FLOAT, y3,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_rotate:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @angle: The angle of rotation (radians).
 *
 * Rotate the specified drawable about its center through the specified
 * angle.
 *
 * This tool rotates the specified drawable if no selection exists. If
 * a selection exists, the portion of the drawable which lies under the
 * selection is cut from the drawable and made into a floating
 * selection which is then rotated by the specified amount. The
 * interpolation parameter can be set to TRUE to indicate that either
 * linear or cubic interpolation should be used to smooth the resulting
 * rotated drawable. The return value is the ID of the rotated
 * drawable. If there was no selection, this will be equal to the
 * drawable ID supplied as input. Otherwise, this will be the newly
 * created and rotated drawable.
 *
 * Returns: The rotated drawable.
 */
gint32
gimp_rotate (gint32   drawable_ID,
	     gboolean interpolation,
	     gdouble  angle)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_rotate",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, angle,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_scale:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @x0: The new x coordinate of upper-left corner of newly scaled region.
 * @y0: The new y coordinate of upper-left corner of newly scaled region.
 * @x1: The new x coordinate of lower-right corner of newly scaled region.
 * @y1: The new y coordinate of lower-right corner of newly scaled region.
 *
 * Scale the specified drawable.
 *
 * This tool scales the specified drawable if no selection exists. If a
 * selection exists, the portion of the drawable which lies under the
 * selection is cut from the drawable and made into a floating
 * selection which is then scaled by the specified amount. The
 * interpolation parameter can be set to TRUE to indicate that either
 * linear or cubic interpolation should be used to smooth the resulting
 * scaled drawable. The return value is the ID of the scaled drawable.
 * If there was no selection, this will be equal to the drawable ID
 * supplied as input. Otherwise, this will be the newly created and
 * scaled drawable.
 *
 * Returns: The scaled drawable.
 */
gint32
gimp_scale (gint32   drawable_ID,
	    gboolean interpolation,
	    gdouble  x0,
	    gdouble  y0,
	    gdouble  x1,
	    gdouble  y1)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_scale",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, x0,
				    GIMP_PDB_FLOAT, y0,
				    GIMP_PDB_FLOAT, x1,
				    GIMP_PDB_FLOAT, y1,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_shear:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @shear_type: Type of shear.
 * @magnitude: The magnitude of the shear.
 *
 * Shear the specified drawable about its center by the specified
 * magnitude.
 *
 * This tool shears the specified drawable if no selection exists. If a
 * selection exists, the portion of the drawable which lies under the
 * selection is cut from the drawable and made into a floating
 * selection which is then sheard by the specified amount. The
 * interpolation parameter can be set to TRUE to indicate that either
 * linear or cubic interpolation should be used to smooth the resulting
 * sheared drawable. The return value is the ID of the sheard drawable.
 * If there was no selection, this will be equal to the drawable ID
 * supplied as input. Otherwise, this will be the newly created and
 * sheard drawable. The shear type parameter indicates whether the
 * shear will be applied horizontally or vertically. The magnitude can
 * be either positive or negative and indicates the extent (in pixels)
 * to shear by.
 *
 * Returns: The sheared drawable.
 */
gint32
gimp_shear (gint32              drawable_ID,
	    gboolean            interpolation,
	    GimpOrientationType shear_type,
	    gdouble             magnitude)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_shear",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_INT32, shear_type,
				    GIMP_PDB_FLOAT, magnitude,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_transform_2d:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @source_x: X coordinate of the transformation center.
 * @source_y: Y coordinate of the transformation center.
 * @scale_x: Amount to scale in x direction.
 * @scale_y: Amount to scale in y direction.
 * @angle: The angle of rotation (radians).
 * @dest_x: X coordinate of where the centre goes.
 * @dest_y: Y coordinate of where the centre goes.
 *
 * Transform the specified drawable in 2d.
 *
 * This tool transforms the specified drawable if no selection exists.
 * If a selection exists, the portion of the drawable which lies under
 * the selection is cut from the drawable and made into a floating
 * selection which is then transformed. The interpolation parameter can
 * be set to TRUE to indicate that either linear or cubic interpolation
 * should be used to smooth the resulting drawable. The transformation
 * is done by scaling the image by the x and y scale factors about the
 * point (source_x, source_y), then rotating around the same point,
 * then translating that point to the new position (dest_x, dest_y).
 * The return value is the ID of the rotated drawable. If there was no
 * selection, this will be equal to the drawable ID supplied as input.
 * Otherwise, this will be the newly created and transformed drawable.
 *
 * Returns: The transformed drawable.
 */
gint32
gimp_transform_2d (gint32   drawable_ID,
		   gboolean interpolation,
		   gdouble  source_x,
		   gdouble  source_y,
		   gdouble  scale_x,
		   gdouble  scale_y,
		   gdouble  angle,
		   gdouble  dest_x,
		   gdouble  dest_y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_transform_2d",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, interpolation,
				    GIMP_PDB_FLOAT, source_x,
				    GIMP_PDB_FLOAT, source_y,
				    GIMP_PDB_FLOAT, scale_x,
				    GIMP_PDB_FLOAT, scale_y,
				    GIMP_PDB_FLOAT, angle,
				    GIMP_PDB_FLOAT, dest_x,
				    GIMP_PDB_FLOAT, dest_y,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}
